#version 330
#extension GL_EXT_gpu_shader4 : enable
// Strange placeMod01.fsh  by   erucipe

//https://www.shadertoy.com/view/4t2Gzy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float pi = 3.141592653589793;

float hash2(vec2 p) {
    return fract(sin(p.x * 15.73 + p.y * 35.29) * 43758.29);    
}

float shash2(vec2 p) {
    return hash2(p) * 2.0 - 1.0;
}

vec2 hash22(vec2 p) {
    return fract(sin(mat2(15.23, 35.76, 75.48, 153.69) * p) * 43758.29);
}

float noise2(vec2 p) {
    vec2 g = floor(p);
    vec2 f = fract(p);
    f = f*f*(3.0 - 2.0*f);
    
    float lt = hash2(g + vec2(0.0, 1.0));
    float rt = hash2(g + vec2(1.0, 1.0));
    float lb = hash2(g + vec2(0.0, 0.0));
    float rb = hash2(g + vec2(1.0, 0.0));
    
    float t = mix(lt, rt, f.x);
    float b = mix(lb, rb, f.x);
    return mix(b, t, f.y);
}

float smin(float a, float b, float k) {
	float h = clamp((b - a) / k * 0.5 + 0.5, 0.0, 1.0);
	return mix(b, a, h) - k * h * ( 1.0 - h);
}

float voronoi(vec2 p) {
    vec2 g = floor(p);
    vec2 f = fract(p);
	f = f*f*f*(6.0*f*f - 15.0*f + 10.0);
    
    float d = 1000.0;
    for(int i = -1; i <= 1; i++) {
        for(int j = -1; j <= 1; j++) {
            vec2 b = vec2(i, j);
            d = smin(d, length(hash22(g + b) + b - f), 0.2);
        }
    }
    return d;
}

float pulse(float d, float w, float k) {
    return smoothstep(w + k, w, d) - smoothstep(-w, -w - k, d);
}

float sdPlane(vec3 p) {
    return p.y - 0.2 * voronoi(p.xz * 2.0) + 2.0 * noise2(p.xz);
}

float sdSphere(vec3 p, float r) {
    return length(p) - r;
}

float map(vec3 p) {
    float r = p.y + 0.5;
    float d = sdPlane(p) * 0.5;
    d = smin(d, r, 0.1);
    return d;
}

vec3 calcNormal(vec3 p) {
    vec2 e = vec2(-1.0, 1.0) * 0.0001;
    return normalize(
        e.xyy * map(p + e.xyy) +
        e.yxy * map(p + e.yxy) +
        e.yyx * map(p + e.yyx) +
        e.xxx * map(p + e.xxx)
    );
}

float softshadow(vec3 ro, vec3 rd, float mint, float maxt, float k) {
    float sh = 1.0;
    float t = mint;
    float h = 0.0;
    for(int i = 0; i < 30; i++) {
        if(t > maxt) continue;
        h = map(ro + rd * t);
        sh = min(sh, k * h / t);
        t += h;
    }
    return sh;
} 
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = gl_FragCoord.xy / iResolution.xy;
    p = 2.0 * p - 1.0;
    p.x *= iResolution.x / iResolution.y;
    
    vec3 ro = vec3(0.0, 1.0, 3.0 - iTime);
    vec3 ta = vec3(0.0, 0.5, 0.0 - iTime);
    vec3 cw = normalize(ta - ro);
    vec3 up = vec3(0.0, 1.0, 0.0);
    vec3 cu = normalize(cross(cw, up));
    vec3 cv = normalize(cross(cu, cw));
    vec3 rd = normalize(p.x * cu + p.y * cv + 3.0 * cw);
    
    float e = 0.0001;
    float t = 0.0;
    float h = e * 2.0;
    for(int i = 0; i < 60; i++) {
        if(h < e || t > 20.0) continue;
        h = map(ro + rd * t);
        t += h;
    }
    
    vec3 pos = ro + rd * t;
    vec3 nor = calcNormal(pos);
    vec3 lig = normalize(vec3(0.0, 0.5, -1.0));
    float dif = dot(nor, lig);
    float fre = dot(nor, rd) + 1.0;
    float fog = clamp(exp(-1.0 * (t - 15.0)), 0.0, 1.0);
    float sh = 0.2 + 0.8 * clamp(softshadow(pos, lig, 0.02, 20.0, 7.0), 0.0, 1.0);
    float j = sin(noise2(pos.xz) * 3.141592 + iTime * 0.1);
    vec3 col = vec3(0.0, cos(j * 3.141592 * 2.0) * 0.5 + 0.5, sin(j * 3.141592 * 20.0) * 0.5) * dif + fre * 0.3;
    col *= sh;
    col += fre * 0.2;
    vec3 sun = vec3(1.0, 1.0, 0.0) * 0.3 / length(p.xy - vec2(0.0, 0.25));
    vec3 bg = vec3(0.8, 0.8 - (p.y * 0.5 + 0.5) * 0.7, 0.7) + sun;
	
    col = mix(bg, col, fog);
    if(t > 20.0) col = bg;
    gl_FragColor = vec4(col, 1.0);
}